/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityVespid;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityCockatrice
extends RideableCreatureEntity
implements IMob {
    protected WanderGoal wanderAI;
    protected AttackMeleeGoal attackAI;
    protected boolean wantsToLand;
    protected boolean isLanded;

    public EntityCockatrice(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.flySoundSpeed = 20;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(false));
        Class<? extends EntityLiving> vespidType = CreatureManager.getInstance().getEntityClass("vespid");
        if (vespidType != null) {
            this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindAttackTargetGoal(this).addTargets(vespidType));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && !this.func_175446_cd()) {
            if (this.isLanded) {
                this.wantsToLand = false;
                if (this.hasPickupEntity() || this.func_184179_bs() != null || this.func_110167_bD() || this.func_70090_H() || !this.isTamed() && this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                    this.leap(1.0, 1.0);
                    this.isLanded = false;
                }
            } else if (this.wantsToLand) {
                if (!this.isLanded && this.isSafeToLand()) {
                    this.isLanded = true;
                }
            } else if (!this.hasPickupEntity() && !this.hasAttackTarget() && this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                this.wantsToLand = true;
            }
            if (this.hasPickupEntity() || this.func_184179_bs() != null || this.hasAttackTarget() || this.func_70090_H()) {
                this.wantsToLand = false;
            } else if (this.isTamed() && !this.func_110167_bD()) {
                this.wantsToLand = true;
            }
        }
        if (!this.isTamed() && !this.func_130014_f_().field_72995_K) {
            if (this.hasAttackTarget()) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.leap(2.0f, 1.0, (Entity)this.func_70638_az());
                }
            } else if (this.field_70146_Z.nextInt(50) == 0 && this.isMoving()) {
                this.leap(1.0, 1.0);
            }
        }
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.wantsToLand || !this.isLanded) {
            BlockPos groundPos = wanderPosition.func_177977_b();
            while (groundPos.func_177956_o() > 0 && this.func_130014_f_().func_180495_p(groundPos).func_177230_c() == Blocks.field_150350_a) {
                groundPos = groundPos.func_177977_b();
            }
            if (this.func_130014_f_().func_180495_p(groundPos).func_185904_a().func_76220_a()) {
                return groundPos.func_177984_a();
            }
        }
        if (this.hasPickupEntity() && this.getPickupEntity() instanceof EntityPlayer) {
            wanderPosition = new BlockPos(wanderPosition.func_177958_n(), this.restrictYHeightFromGround(wanderPosition, 6, 14), wanderPosition.func_177952_p());
        }
        return wanderPosition;
    }

    @Override
    public double getFlightOffset() {
        if (!this.wantsToLand) {
            super.getFlightOffset();
        }
        return 0.0;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityVespid) {
            target.func_70106_y();
        }
        return true;
    }

    public void specialAttack() {
        double distance = 5.0;
        List possibleTargets = this.func_130014_f_().func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), possibleTarget -> possibleTarget.func_70089_S() && possibleTarget != this && !this.func_184215_y((Entity)possibleTarget) && !this.func_184191_r((Entity)possibleTarget) && this.func_70686_a(possibleTarget.getClass()) && this.canAttackEntity((EntityLivingBase)possibleTarget));
        if (!possibleTargets.isEmpty()) {
            for (EntityLivingBase possibleTarget2 : possibleTargets) {
                boolean doDamage = true;
                if (this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget2))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                if (ObjectManager.getEffect("paralysis") != null) {
                    possibleTarget2.func_70690_d(new PotionEffect((Potion)ObjectManager.getEffect("paralysis"), this.getEffectDuration(5), 1));
                }
                if (ObjectManager.getEffect("aphagia") != null) {
                    possibleTarget2.func_70690_d(new PotionEffect((Potion)ObjectManager.getEffect("aphagia"), this.getEffectDuration(5), 1));
                    continue;
                }
                possibleTarget2.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 0));
            }
        }
        this.playAttackSound();
        this.triggerAttackCooldown();
    }

    @Override
    public boolean isFlying() {
        return !this.isLanded || this.hasPickupEntity();
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.7;
    }

    @Override
    public double getMountedZOffset() {
        return -((double)this.field_70130_N) * 0.01;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.specialAttack();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 100.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }
}

